#! /bin/bash

# Resource config
declare -a gpu_list=(0 1 0 1)
declare -a cpu_list=("0-19" "20-39" "10-19" "30-39")
host_name=`uname -n`

# core config
data_name=reddit
GNN_target_path=../result/${data_name}/SAGE
## SDMP config
SDMP_config_root=../config/${data_name}/SDMP
# declare -a SDMP_config_name=("${data_name}_SDMP_mixed_k1_1_k2_3_large_fanout.yml" "${data_name}_SDMP_mixed_k1_1_k2_2_large_fanout.yml")
declare -a SDMP_config_name=("${data_name}_SDMP_150_theta.yml" "${data_name}_SDMP_300_theta.yml")
SDMP_root_result_path=../result/${data_name}_SAGE_SDMP
## test config
declare -a TEST_config_name=("${data_name}_test_SDMP0.yml")
TEST_config_root=../config/${data_name}
TEST_root_result_path=../result/${data_name}_SAGE_SDMP_TEST

#################################################################################
# Don't touch
#################################################################################
# loop for generating SDMP
for ((idx=0; idx<${#SDMP_config_name[@]}; ++idx)); do
    data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
    cur_result_path=${host_name}_${data_time}
    taskset -c ${cpu_list[$idx]} python ../main_gen_SDMP.py --data ../dataset --config ${SDMP_config_root}/${SDMP_config_name[$idx]} --device "cuda:${gpu_list[$idx]}" --result "${SDMP_root_result_path}/${cur_result_path}" --gnn $GNN_target_path > /dev/null &
    pids[$idx]=$!
    sleep 1
done 
echo "Done this round of start!"
for pid in ${pids[*]}; do
    wait $pid
done

# loop for testing the SDMP
for ((out_idx=0; out_idx<${#TEST_config_name[@]}; ++out_idx)); do
    idx=0
    for dict_folder in ${SDMP_root_result_path}/*; do
        data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
        cur_result_path=${host_name}_${data_time}
        taskset -c ${cpu_list[$idx]} python ../main_test_SDMP.py --data ../dataset --dict $dict_folder --config ${TEST_config_root}/${TEST_config_name[$out_idx]} --device "cuda:${gpu_list[$idx]}" --result "${TEST_root_result_path}/${cur_result_path}" --gnn $GNN_target_path> /dev/null &
        pids[$idx]=$!
        idx=$((idx+1))
        sleep 2
    done
    echo "Done this round of start!"
    for pid in ${pids[*]}; do
        wait $pid
    done
done

